<div class="wslu-admin-card wslu-admin-card-shadow">
    <img src="<?php echo esc_url(self::get_url() . 'assets/images/banner_dashboard.png'); ?>" class="wslu-admin-dashboard-banner" />
</div>

<!-- Documentation -->
<div class="wslu-admin-section wslu-admin-dual-layout wslu-admin-documentation-section">
    <div class="wslu-admin-left-thumb">
        <img src="<?php echo esc_url(self::get_url() . 'assets/images/documentation-thumb.png'); ?>" alt="<?php esc_attr_e('Documentation Thumb', 'wp-social'); ?>">
    </div>
    <div class="wslu-admin-right-content">
        <div class="wslu-admin-right-content--heading">
            <h2><?php esc_html_e('Easy Documentation', 'wp-social') ?></h2>
            <span class="wslu-admin-right-content--heading__sub-title"><?php esc_html_e('Docs', 'wp-social') ?></span>
        </div> 
        <p><?php esc_html_e('Get started by spending some time with the documentation to get familiar with ElementsKit Lite. Build awesome websites for you or your clients with ease.', 'wp-social'); ?></p>
        <div class="wslu-admin-right-content--button">
            <a target="_blank" href="https://wpmet.com/elementskit-docs" class="attr-btn attr-btn-primary wslu-admin-right-content--link"><i class="fa fa-newspaper-o"></i><?php esc_html_e('Get started', 'wp-social'); ?></a>
        </div>
    </div>
</div>

<!-- Video tutorials -->
<div class="wslu-admin-section wslu-admin-faq-section">
    <div class="wslu-admin-right-content attr-text-center">
        <div class="wslu-admin-right-content--heading">
            <h2><?php esc_html_e('Video Tutorials', 'wp-social') ?></h2>
            <span class="wslu-admin-right-content--heading__sub-title"><?php esc_html_e('Tutorials', 'wp-social') ?></span>
        </div> 
        <p><?php esc_html_e('Get started by spending some time with the documentation to get familiar with ElementsKit Lite.', 'wp-social'); ?></p>
    </div>

    <div class="wslu-admin-video-tutorial-list">
        <div class="wslu-admin-video-tutorial-item">
            <a target="_blank" href="https://wpmet.com/plugin/elementskit/parallax-landing/">
                <div class="tutorial-thumb">
                    <img src="<?php echo esc_url(self::get_url() . 'assets/images/suport-thumb.png'); ?>" alt="<?php esc_attr_e('Totorial Thumb', 'wp-social'); ?>">
                </div>
                <h2><?php esc_html_e('Parallax Effects', 'wp-social'); ?></h2>
            </a>
        </div>
        <div class="wslu-admin-video-tutorial-item">
            <a href="#" data-video_id="oV-7-NNiGZo">
                <div class="tutorial-thumb">
                    <img src="<?php echo esc_url(self::get_url() . 'assets/images/subscribed-thumb.png'); ?>" alt="<?php esc_attr_e('Totorial Thumb', 'wp-social'); ?>">
                </div>
                <h2><?php esc_html_e('Advanced Accordions', 'wp-social'); ?></h2>
            </a>
        </div>
        <div class="wslu-admin-video-tutorial-item">
            <a href="#" data-video_id="LfFN08Y9VQE">
                <div class="tutorial-thumb">
                    <img src="<?php echo esc_url(self::get_url() . 'assets/images/featured-request-thumb.png'); ?>" alt="<?php esc_attr_e('Totorial Thumb', 'wp-social'); ?>">
                </div>
                <h2><?php esc_html_e('Mega Menu Builder', 'wp-social'); ?></h2>
            </a>
        </div>
    </div>
    <div class="ekti-admin-video-tutorial-popup">
        <div class="ekti-admin-video-tutorial-popup-content">
            <div class="ekti-admin-video-tutorial-iframe"></div>
            <div class="ekti-admin-video-tutorial-close"><i class="fa fa-times"></i></div>
        </div>
    </div>

    
    <div class="wslu-admin-right-content--button attr-text-center">
        <a target="_blank" href="https://www.youtube.com/watch?v=ps7knxZpDFI&list=PL3t2OjZ6gY8MVnyA4OLB6qXb77-roJOuY" class="attr-btn attr-btn-primary wslu-admin-right-content--link"><i class="fa fa-check-circle"></i><?php esc_html_e('watch more videos', 'wp-social'); ?></a>
    </div>
</div>

<!-- FAQ -->
<div class="wslu-admin-section wslu-admin-faq-section" style="display: none">
    <div class="wslu-admin-right-content attr-text-center">
        <div class="wslu-admin-right-content--heading">
            <h2><?php esc_html_e('General Knowledge Base', 'wp-social') ?></h2>
            <span class="wslu-admin-right-content--heading__sub-title"><?php esc_html_e('FAQ', 'wp-social') ?></span>
        </div> 
        <p><?php esc_html_e('Get started by spending some time with the documentation to get familiar with ElementsKit Lite.', 'wp-social'); ?></p>
    </div>

    <div class="wslu-admin-accordion">
        <div class="wslu-admin-single-accordion">
            <h2 class="wslu-admin-single-accordion--heading"><?php esc_html_e('1. How to create a shop page in ElementsKit Lite?', 'wp-social'); ?></h2>
            <div class="wslu-admin-single-accordion--body">
                <div class="wslu-admin-single-accordion--body__content">
                    <p><?php esc_html_e('You will get 20+ complete homepages and total 450+ blocks in our layout library and we’re continuously updating the numbers there.', 'wp-social'); ?></p>
                </div>
            </div>
        </div>
        <div class="wslu-admin-single-accordion">
            <h2 class="wslu-admin-single-accordion--heading"><?php esc_html_e('2. How to translate theme with WPML?', 'wp-social'); ?></h2>
            <div class="wslu-admin-single-accordion--body">
                <div class="wslu-admin-single-accordion--body__content">
                    <p><?php esc_html_e('You will get 20+ complete homepages and total 450+ blocks in our layout library and we’re continuously updating the numbers there.', 'wp-social'); ?></p>
                </div>
            </div>
        </div>
        <div class="wslu-admin-single-accordion">
            <h2 class="wslu-admin-single-accordion--heading"><?php esc_html_e('3. How to add custom css in specific section shortcode?', 'wp-social'); ?></h2>
            <div class="wslu-admin-single-accordion--body">
                <div class="wslu-admin-single-accordion--body__content">
                    <p><?php esc_html_e('You will get 20+ complete homepages and total 450+ blocks in our layout library and we’re continuously updating the numbers there.', 'wp-social'); ?></p>
                </div>
            </div>
        </div>
    </div>

    
    <div class="wslu-admin-right-content--button attr-text-center">
        <a target="_blank" href="https://www.youtube.com/channel/UCpsjAqTeTqwFTMV580D3YvQ" class="attr-btn attr-btn-primary wslu-admin-right-content--link"><i class="fa fa-question-circle"></i><?php esc_html_e('View all faq’s', 'wp-social'); ?></a>
    </div>
</div>

<!-- Support -->
<div class="wslu-admin-section wslu-admin-dual-layout wslu-admin-support-section">
<div class="wslu-admin-right-content">
        <div class="wslu-admin-right-content--heading">
            <h2><?php esc_html_e('Top-notch Friendly Support', 'wp-social') ?></h2>
            <span class="wslu-admin-right-content--heading__sub-title"><?php esc_html_e('Support', 'wp-social') ?></span>
        </div> 
        <p><?php esc_html_e('Get started by spending some time with the documentation to get familiar with ElementsKit Lite. Build awesome websites for you or your clients with ease.', 'wp-social'); ?></p>
        <div class="wslu-admin-right-content--button">
            <a target="_blank" href="https://wpmet.com/support-ticket" class="attr-btn attr-btn-primary wslu-admin-right-content--link"><i class="fa fa-question-circle"></i><?php esc_html_e('Join support forum', 'wp-social'); ?></a>
        </div>
    </div>
    
    <div class="wslu-admin-left-thumb">
        <img src="<?php echo esc_url(self::get_url()) . 'assets/images/suport-thumb.png'; ?>" alt="<?php esc_attr_e('Documentation Thumb', 'wp-social'); ?>">
    </div>
    
</div>

<!-- Feature a Request -->
<div class="wslu-admin-section wslu-admin-dual-layout wslu-admin-feature-request-section wslu-admin-except-title">
    <div class="wslu-admin-left-thumb">
        <img src="<?php echo esc_url(self::get_url()) . 'assets/images/featured-request-thumb.png'; ?>" alt="<?php esc_attr_e('Feature a Request Thumb', 'wp-social'); ?>">
    </div>
    <div class="wslu-admin-right-content">

        <p><?php esc_html_e('Maybe we’re missing something you can’t live without.', 'wp-social'); ?></p>
        <div class="wslu-admin-right-content--button">
            <a target="_blank" href="https://wpmet.com/feature-request" class="attr-btn attr-btn-primary wslu-admin-right-content--link"><i class="fa fa-check-circle"></i><?php esc_html_e('Feature a request', 'wp-social'); ?></a>
        </div>
    </div>
</div>

<!-- Rate Now -->
<div class="wslu-admin-section wslu-admin-dual-layout wslu-admin-rate-now-section wslu-admin-except-title">
    
    <div class="wslu-admin-right-content">

        <p><span><?php esc_html_e('Satisfied?', 'wp-social'); ?></span><?php esc_html_e('Don’t forget to rate our item.', 'wp-social'); ?></p>
        <div class="wslu-admin-right-content--button">
            <a target="_blank" href="https://wordpress.org/support/plugin/elementskit-lite/reviews/?rate=5#new-post" class="attr-btn attr-btn-primary wslu-admin-right-content--link"><i class="fa fa-star"></i><?php esc_html_e('Rate it now', 'wp-social'); ?></a>
        </div>
    </div>

    <div class="wslu-admin-left-thumb">
        <img src="<?php echo esc_url(self::get_url()) . 'assets/images/rate-now-thumb.png'; ?>" alt="<?php esc_attr_e('Rate Now Thumb', 'wp-social'); ?>">
    </div>
</div>